import com.liferay.portal.kernel.log.LogFactoryUtil
import com.liferay.portal.model.Layout
import com.liferay.portal.model.ResourceConstants
import com.liferay.portal.security.permission.ActionKeys
import com.liferay.portal.service.LayoutLocalServiceUtil
import com.liferay.portal.service.ResourcePermissionServiceUtil
import com.liferay.portal.service.RoleLocalServiceUtil
import com.liferay.portal.util.PortalUtil


/*
 *  consts and vars
 */
def log = LogFactoryUtil.getLog( 'Update permissions' )

def companyId = PortalUtil.defaultCompanyId
def SES_MEMBER_ROLE = RoleLocalServiceUtil.getRole( companyId, 'SES_MEMBER' )
def STAFF_ROLE = RoleLocalServiceUtil.getRole( companyId, 'STAFF' )

def groupId = 381376 //hub staging
def privateLayouts = true

/*
 *  Functions
 */
/**
 * Wrapper around ResourcePermissionLocalServiceUtil.addResourcePermission
 */
def setResourcePermission = { String className, String primaryKey, Long roleId ->
    ResourcePermissionServiceUtil.setIndividualResourcePermissions(groupId,
            companyId, Layout.class.getName(), primaryKey, roleId, [ActionKeys.VIEW] as String[]);
}



ResourceConstants.SCOPE_GROUP_TEMPLATE
/**
 * 
 * @returns a truth if the resource has the view permission for the STAFF role
 */
def hasStaffMemberViewPermission = { className, primaryKey ->
    return ResourceConstants.SCOPES.find { scope ->
        def viewRoles = RoleLocalServiceUtil.getResourceRoles( companyId, className, scope, primaryKey, 'VIEW' )

        return viewRoles.find {
            it.roleId == STAFF_ROLE.roleId
        }
    }
}

/*
 *  Excecution
 */


def groupLayouts = LayoutLocalServiceUtil.getLayouts( groupId, privateLayouts )

def layoutsNoStaffMember = groupLayouts.findAll {
    def hasResourcePermission = hasStaffMemberViewPermission( Layout.class.getName(), String.valueOf( it.primaryKey ) )

    def logLine = ( hasResourcePermission ? 'Skipping' : 'Updating' ) + " ${it.getName('en_AU')} ( /group${it.group.friendlyURL}${it.friendlyURL} )".toString()

    log.info logLine
    out.println logLine

    return !hasResourcePermission
}

layoutsNoStaffMember.each {
    // DRY RUN!!! Uncomment the method below to set the permissions
    //setResourcePermission( Layout.class.getName(), String.valueOf( it.primaryKey ), SES_MEMBER_ROLE.roleId )

    def logLine = "Updated ${it.getName('en_AU')} ( /group${it.group.friendlyURL}${it.friendlyURL} )"
    log.info logLine
    out.println logLine.toString()
}